/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.pa.ar;

import com.ibm.hwmca.base.pa.ar.CommonSystemAnalysisRoutine;
import com.ibm.hwmca.base.pa.domain.ConsoleAnalysisDomain;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.pa.incident.IncidentPool;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfaces;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfacesException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.fru.PIFru;
import com.ibm.hwmca.xfw.pa.event.CommonServiceAREvent;
import com.ibm.hwmca.xfw.pa.fru.CommonFruList;
import com.ibm.hwmca.xfw.pa.incident.CommonServiceIncident;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.util.ArrayList;
import java.util.Iterator;

public class PIConsoleDomainAnalysisRoutine
extends CommonSystemAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "XPACDART";
    private static final String TRACE_MASKF = "XPACDARF";
    private static final String TRACE_MASKD = "XPACDARD";

    public PIConsoleDomainAnalysisRoutine() {
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent event) {
        Trace.trace(TRACE_MASKD, "--> analyze()");
        super.analyze(event);
        boolean isPHMC = false;
        try {
            byte[] bHMCType = SimServer.getSimServer().readSim(5);
            isPHMC = bHMCType != null && bHMCType[0] == 4;
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "Exception reading XCPC_STATUS SIM field");
            Trace.trace(TRACE_MASKF, e);
        }
        if (!isPHMC) {
            Trace.trace(TRACE_MASKD, "this is an HMC no need for swapping refcodes ");
            return;
        }
        Trace.trace(TRACE_MASKD, "back now we need to swap our refcode information");
        String poolId = ((CommonServiceAREvent)event).getIncidentPoolId();
        IncidentPool thePool = PIConsoleDomainAnalysisRoutine.getAnalyzingIncidentPool(poolId);
        Iterator ipi = thePool.iterator();
        Trace.trace(TRACE_MASKD, "our pool iterator has more =  " + ipi.hasNext());
        CommonFruList myFruList = new CommonFruList();
        PIFru myPIFru = null;
        try {
            myPIFru = (PIFru)ServiceInterfaces.getFactory("com.ibm.hwmca.fw.pa.system.PASystem", "Fru");
            myPIFru.setPartNumber("HMCLIC");
            myPIFru.setReplacementGroup("M");
            myPIFru.setFruClass(12);
            ConsoleAnalysisDomain cad = (ConsoleAnalysisDomain)DomainManager.getDomainManager().get(ConsoleAnalysisDomain.CAD_DOMAINID);
            myPIFru.setLogicControllingSystem(cad.getConsoleSystem());
            myPIFru.setPowerControllingSystem(cad.getConsoleSystem());
        }
        catch (ServiceInterfacesException e1) {
            e1.printStackTrace();
            Trace.trace(TRACE_MASKT, "Could not get a fru exit  ");
            return;
        }
        ArrayList<PIFru> myList = new ArrayList<PIFru>();
        myList.add(myPIFru);
        myFruList.setFrus(myList);
        while (ipi.hasNext()) {
            CommonServiceIncident curIncident = (CommonServiceIncident)ipi.next();
            CommonProblem curProblem = curIncident.getProblem();
            String replaceClass = null;
            String refcodePrefix = curProblem.getRefcode().substring(0, 2);
            if (refcodePrefix.equals("E2") || refcodePrefix.equals("E3")) {
                curProblem.addFruList(myFruList);
            } else if (refcodePrefix.equals("A0")) {
                replaceClass = "E2";
                curProblem.addFruList(myFruList);
            } else if (refcodePrefix.equals("AA")) {
                replaceClass = "E3";
                curProblem.addFruList(myFruList);
            } else if (refcodePrefix.equals("B0")) {
                replaceClass = "B31";
            } else if (refcodePrefix.equals("BC")) {
                replaceClass = "B32";
            }
            if (replaceClass == null) continue;
            Trace.trace(TRACE_MASKD, "swapping refcode class original = " + curProblem.getRefcode() + " replace class with " + replaceClass + " new will be " + replaceClass + curProblem.getRefcode().substring(replaceClass.length()));
            curProblem.setRefcode(replaceClass + curProblem.getRefcode().substring(replaceClass.length()));
        }
        Trace.trace(TRACE_MASKD, "<-- analyze()");
    }
}

